//=============================================================================
// Crazy JumpBoots
//=============================================================================
class CrazyJumpBoots extends UT_JumpBoots;

#exec TEXTURE IMPORT NAME=CrazyJump FILE=E:\UnrealTournament\CrazyInventory\Textures\CrazyJump.PCX LODSET=2
#exec AUDIO IMPORT FILE="E:\UnrealTournament\CrazyInventory\Sounds\CrazyJumpSnd.WAV" NAME="CrazyJumpSnd"

var int TimeCharge;

function PickupFunction(Pawn Other)
{
	TimeCharge = 0;
	SetTimer(1.0, True);
}

function ResetOwner()
{
	local pawn P;

	P = Pawn(Owner);
	P.JumpZ = P.Default.JumpZ * Level.Game.PlayerJumpZScaling();
	if ( Level.Game.IsA('DeathMatchPlus') )
		P.AirControl = DeathMatchPlus(Level.Game).AirControl;
	else
		P.AirControl = P.Default.AirControl;
	P.bCountJumps = False;
}

function OwnerJumped()
{
	if ( !Pawn(Owner).bIsWalking )
	{
		TimeCharge=0;
		if ( Charge <= 0 )
		{
			if ( Owner != None )
			{
				Owner.PlaySound(DeActivateSound);
				ResetOwner();
			}
			UsedUp();
		}
		else
			Owner.PlaySound(sound'CrazyJumpSnd');
		Charge -= 1;
	}
	if( Inventory != None )
		Inventory.OwnerJumped();

}

function Timer()
{
	if ( Charge <= 0 )
	{
		if ( Owner != None )
		{
			if ( Owner.Physics == PHYS_Falling )
			{
				SetTimer(0.3, true);
				return;
			}
			Owner.PlaySound(DeActivateSound);
			ResetOwner();
		}
		UsedUp();
		return;
	}

	if ( !Pawn(Owner).bAutoActivate )
	{
		TimeCharge++;
		if (TimeCharge>20)
		{
			OwnerJumped();
			TimeCharge = 0;
		}
	}
}

state Activated
{
	function endstate()
	{
		ResetOwner();
		bActive = false;
	}
Begin:
	Pawn(Owner).bCountJumps = True;
	Pawn(Owner).AirControl = 1.0;
	Pawn(Owner).JumpZ = Pawn(Owner).Default.JumpZ * 5;
	Owner.PlaySound(ActivateSound);
}

state DeActivated
{
Begin:
}




defaultproperties
{
     ExpireMessage="The |Crazy| enhanced JumpBoots has drained."
     PickupMessage="You picked up the |Crazy| enhanced JumpBoots."
//     //ActivateSound=Sound'CrazyInventory.CrazyJumpSnd' // lyd nr de samles op
//     DeActivateSound=Sound'CrazyInventory.CrazyJumpSnd' // lyd nr de er brugt op
     MultiSkins(1)=Texture'CrazyInventory.CrazyJump'
}